float4x4 mWorldViewProj;
float4x4 mWorldViewInv;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 UV			: TEXCOORD0;
    float3 Normal		: TEXCOORD1;
};

VS_OUTPUT main( in float4 pos : POSITION,

				in float3 normal : NORMAL0,
				in float2 uv : TEXCOORD0
				
				)
{
	VS_OUTPUT Output;
	
	Output.UV = uv;
    Output.Position = mul(pos, mWorldViewProj);
    Output.Normal = mul(mWorldViewInv, normal);
    
       
    return Output;
}